#!/bin/sh
set -e
install()
{
  if [ $# -ne 1 ] || ! [ -d "$1" ]; then
    >&2 printf '%s:usage: install <prefix>\n' "${0##*/}"
    return 1
  fi
  path=$(cd -- "$1" && pwd)
  mkdir -p "${path}/lib/pkgconfig"
  sed "s#@PREFIX@#${path}#" "${path}/share/spkg/embree4.pc.in" \
    > "$1/lib/pkgconfig/embree4.pc"
}
uninstall()
{
  if [ $# -ne 1 ]; then
    >&2 printf '%s:usage: uninstall <prefix>\n' "${0##*/}"
    return 1
  fi
  rm -f "$1/lib/pkgconfig/embree4.pc"
  rm -f "$1/include/embree4/rtcore.h"
  rm -f "$1/include/embree4/rtcore_device.isph"
  rm -f "$1/include/embree4/rtcore_buffer.isph"
  rm -f "$1/include/embree4/rtcore.isph"
  rm -f "$1/include/embree4/rtcore_common.isph"
  rm -f "$1/include/embree4/rtcore_ray.h"
  rm -f "$1/include/embree4/rtcore_ray.isph"
  rm -f "$1/include/embree4/rtcore_quaternion.isph"
  rm -f "$1/include/embree4/rtcore_geometry.h"
  rm -f "$1/include/embree4/rtcore_quaternion.h"
  rm -f "$1/include/embree4/rtcore_buffer.h"
  rm -f "$1/include/embree4/rtcore_builder.h"
  rm -f "$1/include/embree4/rtcore_scene.isph"
  rm -f "$1/include/embree4/rtcore_device.h"
  rm -f "$1/include/embree4/rtcore_geometry.isph"
  rm -f "$1/include/embree4/rtcore_common.h"
  rm -f "$1/include/embree4/rtcore_scene.h"
  rm -f "$1/include/embree4/rtcore_config.h"
  rm -f "$1/lib/libtbbmalloc.so.2.12"
  rm -f "$1/lib/libtbbmalloc.so.2"
  rm -f "$1/lib/libtbbmalloc.so"
  rm -f "$1/lib/libtbb.so"
  rm -f "$1/lib/libtbb.so.12.12"
  rm -f "$1/lib/libtbb.so.12"
  rm -f "$1/lib/libembree4.so"
  rm -f "$1/lib/libembree4.so.4"
  rm -f "$1/share/spkg/embree4.pc.in"
  rm -f "$1/share/spkg/embree4.sh"
  rm -f "$1/share/doc/embree/readme.pdf"
  rm -f "$1/share/doc/embree/third-party-programs.txt"
  rm -f "$1/share/doc/embree/third-party-programs-OIDN.txt"
  rm -f "$1/share/doc/embree/third-party-programs-DPCPP.txt"
  rm -f "$1/share/doc/embree/third-party-programs-TBB.txt"
  rm -f "$1/share/doc/embree/third-party-programs-oneAPI-DPCPP.txt"
  rm -f "$1/share/doc/embree/README.md"
  rm -f "$1/share/doc/embree/CHANGELOG.md"
  rm -f "$1/share/doc/embree/LICENSE.txt"
}
"$@"
