#!/bin/sh -e

# Copyright (C) 2023-2025 Centre National de la Recherche Scientifique
# Copyright (C) 2023-2025 Institut Pierre-Simon Laplace
# Copyright (C) 2023-2025 Institut de Physique du Globe de Paris
# Copyright (C) 2023-2025 |Méso|Star> (contact@meso-star.com)
# Copyright (C) 2023-2025 Observatoire de Paris
# Copyright (C) 2023-2025 Université de Reims Champagne-Ardenne
# Copyright (C) 2023-2025 Université de Versaille Saint-Quentin
# Copyright (C) 2023-2025 Université Paul Sabatier
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

path="$(dirname "${0}")/titan"

gas="${gas}:mesh=${path}/gas_grid.bin"
gas="${gas}:ck=${path}/gas_radiative_properties.bin"
gas="${gas}:temp=${path}/gas_thermodynamic_properties.bin"

haze="${haze}:name=haze"
haze="${haze}:mesh=${path}/haze_grid.bin"
haze="${haze}:radprop=${path}/haze_radiative_properties.bin"
haze="${haze}:phasefn=${path}/haze_phase_function_list.txt"
haze="${haze}:phaseids=${path}/haze_phase.bin"

cloud="${cloud}:name=cloud"
cloud="${cloud}:mesh=${path}/cloud_grid.bin"
cloud="${cloud}:radprop=${path}/cloud_radiative_properties.bin"
cloud="${cloud}:phasefn=${path}/cloud_phase_function_list.txt"
cloud="${cloud}:phaseids=${path}/cloud_phase.bin"

ground="${ground}:name=titan_surface"
ground="${ground}:mesh=${path}/sphere.bin"
ground="${ground}:prop=${path}/surface_properties.bin"
ground="${ground}:brdf=${path}/materials_list.txt"

source="${source}:lon=-60:lat=-40"
source="${source}:dst=1.495978707e8"
source="${source}:radius=6.96342e5"
source="${source}:temp=5773"

camera="${camera}:pos=12000000,0.0,0.0"
camera="${camera}:tgt=0.0,0.0,0.0"
camera="${camera}:up=0.0,0.0,1.0"
camera="${camera}:fov=30"

image_def="1280x960"
image_spp="256"
image="def=${image_def}:spp=${image_spp}"

spectral="cie_xyz"

octrees_tau="1"
octrees_def="256"
octrees="${octrees}:tau=${octrees_tau}"
octrees="${octrees}:def=${octrees_def}"
octrees="${octrees}:proc=master"
octrees="${octrees}:nthreads=8"
octrees="${octrees}:storage=titan_octrees${octrees_def}_${spectral}_T${octrees_tau}.bin"

output="titan_${image_def}x${image_spp}.txt"

force_overwrite="-f"
precompute_tetra_normals="-N"
verbose="-v"

export DATA_PATH="${path}"

set -x
htrdr-planets\
 "${force_overwrite}"\
 "${precompute_tetra_normals}"\
 "${verbose}"\
 -G "${ground}"\
 -g "${gas}"\
 -a "${haze}"\
 -a "${cloud}"\
 -S "${source}"\
 -s "${spectral}"\
 -C "${camera}"\
 -i "${image}"\
 -b "${octrees}"\
 -o "${output}"
